<?php

/**
 *  总熟练度
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\ProficiencyData;
use Game\Data\TaskData;
use Game\Logic\AccountLogic;

class TaskLogicTotalProficiency extends TaskLogicBase
{
    use AccountLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        if ($this->isRegister) {
            $lv = 1;
        } else {
            $lv = $this->getAccountProperty($this->playerId, ProficiencyData::PROFICIENCY_LV, 0);
        }
        if (is_null($lv)) {
            return;
        }
        $this->updateTaskSchedule($taskData, $lv);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => 增加等级
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        if (!isset($param[GameConstantDefine::EVENT_KEY_NUM])) {
            return;
        }
        $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
