<?php

/**
 * 送礼:包含好友列表送礼,对局结束送礼,总计送礼
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\TaskData;

class TaskLogicSendGift extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => num
     *      EVENT_KEY_SEND_GIFT_FROM 送礼来源 => EVENT_VALUE_LIKE_FRIEND EVENT_VALUE_LIKE_MATCH
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        // 检查送礼类型
        switch ($taskData->taskConfig[TemplateTask::ConditionType])
        {
            case TaskLogicDefine::TASK_CONDITION_COUNT_SEND_GIFT:
                // 总送礼次数
                $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                break;
            case TaskLogicDefine::TASK_CONDITION_FRIEND_SEND_GIFT:
                // 好友送礼
                if ($param[GameConstantDefine::EVENT_KEY_SEND_GIFT_FROM] == GameConstantDefine::EVENT_VALUE_SEND_GIFT_FRIEND) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SEND_GIFT:
                // 对局送礼
                if ($param[GameConstantDefine::EVENT_KEY_SEND_GIFT_FROM] == GameConstantDefine::EVENT_VALUE_SEND_GIFT_MATCH) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                }
                break;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
