<?php

/**
 * 排位赛积分
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\AccountData;
use Game\Data\TaskData;
use Game\Logic\AccountLogic;

class TaskLogicPlayerLevel extends TaskLogicBase
{
    use AccountLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //检查玩家等级
        if ($this->isRegister) {
            $level = 1;
        } else {
            $level = $this->getAccountProperty($this->playerId, AccountData::DB_LEVEL, 1);
        }
        $this->updateTaskSchedule($taskData, $level);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    public function updateTask(TaskData $taskData, array $param)
    {
        $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_PLAYER_LEVEL]);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
