<?php

/**
 * 与有亲密关系的好友共同游戏
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\TaskData;
use Game\Model\Friend\FriendIntimacyModel;

class TaskLogicPlayWithFriend extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        if ($this->checkHasIntimacyFriend($param[GameConstantDefine::EVENT_KEY_FRIEND_IDS])) {
            $this->updateTaskSchedule($taskData, 1);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }

    //检查是否有亲密好友
    private function checkHasIntimacyFriend(array $friendIds): bool
    {
        /**
         * @var FriendIntimacyModel $friendIntimacyModel
         */
        $friendIntimacyModel = ModelManager::getInstance()->getModel(ModelTypeDefine::FRIEND_INTIMACY);
        foreach ($friendIds as $targetPlayerId) {
            $friendIntimacyModel->setRespondentPlayerId($targetPlayerId);
            //检查与对方是否有关系
            if ($friendIntimacyModel->checkHasIntimacy()) {
                return true;
            }
        }
        return false;
    }
}
