<?php

/**
 * 排位赛积分
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\PaiWei\PaiweiLevelData;
use Game\Data\TaskData;
use Game\Logic\PaiweiLevelLogic;

class TaskLogicPaiWei extends TaskLogicBase
{
    use PaiweiLevelLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //新号初始段位为1,积分为0
        if ($this->isRegister) {
            $paiweiData = new PaiweiLevelData();
            $paiweiData->levelId = 1;
            $paiweiData->score = 0;
        } else {
            // 获取当前排位积分
            $paiweiData = $this->getPaiweiLevel();
        }
        switch ($taskData->taskConfig[TemplateTask::ConditionType])
        {
            case TaskLogicDefine::TASK_CONDITION_MATCH_PAI_WEI_SCORE:
                //排位积分
                $this->updateTaskSchedule($taskData, $paiweiData->score);
                break;
            case TaskLogicDefine::TASK_CONDITION_PAI_WEI_LEVEL:
                //排位段位
                $this->updateTaskSchedule($taskData, $paiweiData->levelId);
                break;
        }

        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => 获得积分
     *      EVENT_KEY_PAI_WEI_LEVEL => 段位
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        switch ($taskData->taskConfig[TemplateTask::ConditionType]) {
            case TaskLogicDefine::TASK_CONDITION_MATCH_PAI_WEI_SCORE:
                //排位积分
                $score = $param[GameConstantDefine::EVENT_KEY_NUM];
                if ($score > 0) {
                    $this->updateTaskSchedule($taskData, $score);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_PAI_WEI_LEVEL:
                //排位段位
                $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_PAI_WEI_LEVEL]);
                break;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
