<?php

/**
 * 在线时间
 */

namespace Game\Model\Task\Logic;

use Framework\Lib\Utils;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Constant\TemplateDefine;
use Game\Data\EventConditionData;
use Game\Data\TaskData;
use Game\Logic\EventConditionLogic;

class TaskLogicOnlineTime extends TaskLogicBase
{
    use EventConditionLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        $onlineTime = $this->getOnlineTime();
        $this->dealOnlineTimeTask($taskData, $onlineTime);
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => 增加时间 秒
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $this->dealOnlineTimeTask($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
    }

    // 获取当日 在线时长
    private function getOnlineTime(): int
    {
        //新号初始在线时间为0
        if ($this->isRegister) {
            return 0;
        }
        return $this->getSingleEventConditionValue(EventConditionData::EVENT_CONDITION_KEY_ONLINE_TIME);
    }

    //处理在线时间
    private function dealOnlineTimeTask(TaskData $taskData, int $time)
    {
        if ($taskData->taskConfig[TemplateTask::ConditionType] == TaskLogicDefine::TASK_CONDITION_DAY_ONLINE_TIME) {
            //新号初始不需要检查每天在线时长任务
            if ($this->isRegister) {
                return;
            }
            //每日在线天数任务(任务条件70012),在线时间
            $configOnlineTime = (int)$this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Task_Online_Pre_Day_Minute,
                TemplateConst::ConstNum);
            $onlineTime = $this->getOnlineTime();
            //检查是否完成任务
            if ($onlineTime >= $configOnlineTime && ($taskData->triggerDate == 0 || Utils::checkIsCrossDay($taskData->triggerDate))) {
                $taskData->schedule++;
                $taskData->isChange = true;
                $taskData->triggerDate = Utils::getServerTimestamp();
            }
        } else {
            $this->updateTaskSchedule($taskData, $time);
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
