<?php

/**
 * pvp 比赛排名
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\TaskData;

class TaskLogicMatchRank extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_MATCH_RANK => 名次
     *      EVENT_KEY_MATCH_TYPE
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        switch ($taskData->taskConfig[TemplateTask::ConditionType]) {
            case TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_3:
                // 前三名次数
                $isComp = false;
                foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                    if (intval($cond[0]) == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE] &&
                        $param[GameConstantDefine::EVENT_KEY_MATCH_RANK] <= 3
                    ) {
                        $isComp = true;
                        break;
                    }
                }
                if ($isComp) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_1:
                // 第一次数
                $isComp = false;
                foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                    if (intval($cond[0]) == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE] &&
                        $param[GameConstantDefine::EVENT_KEY_MATCH_RANK] == 1
                    ) {
                        $isComp = true;
                        break;
                    }
                }
                if ($isComp) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_3_COMMON:
                // 前三名次数
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_RANK] <= 3) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_2_COMMON:
                // 前两名次数
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_RANK] <= 2) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_1_COMMON:
                // 第一次数
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_RANK] == 1) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            default:
                return;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
