<?php

/**
 * 比赛内 漂移 技能等操作
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\RecordData;
use Game\Data\TaskData;
use Game\Protobuf\MatchOperation;
use Game\Protobuf\TaleTarget;

class TaskLogicMatchOperation extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_MATCH_OPERATION => PvpMatchOperation
     *      EVENT_KEY_MATCH_RECORD => RecordData
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        //支线任务检查
        if ($taskData->taskConfig[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_BRANCH) {
            //检查车Id
            if ($taskData->taskConfig[TemplateTask::GroupType] != $param[GameConstantDefine::EVENT_KEY_CAR_ID]) {
                return;
            }
        }
        /**
         * @var MatchOperation $matchOperation
         */
        $matchOperation = $param[GameConstantDefine::EVENT_KEY_MATCH_OPERATION];
        /**
         * @var TaleTarget $taleTarget
         */
        $taleTarget = $param[GameConstantDefine::EVENT_KEY_PVP_OPERATION];
        /**
         * @var RecordData $record
         */
        $record = $param[GameConstantDefine::EVENT_KEY_MATCH_RECORD];
        switch ($taskData->taskConfig[TemplateTask::ConditionType]) {
            case TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_1_NUM:
                // 小喷次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getSpray1Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON:
                // 小喷次数
                $this->updateTaskSchedule($taskData, $matchOperation->getSpray1Num());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_2_NUM:
                // 双喷次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getSpray2Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON:
                // 双喷次数
                $this->updateTaskSchedule($taskData, $matchOperation->getSpray2Num());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_N2_NUM:
                // 氮气次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getN2Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_N2_NUM_COMMON:
                // 氮气次数
                $this->updateTaskSchedule($taskData, $matchOperation->getN2Num());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_NUM:
                // 漂移次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getDriftNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_NUM_COMMON:
                // 漂移次数
                $this->updateTaskSchedule($taskData, $matchOperation->getDriftNum());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_RANGE:
                // 漂移距离 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getDriftRange());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON:
                // 漂移距离
                $this->updateTaskSchedule($taskData, $matchOperation->getDriftRange());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_OVER_TAKE_NUM:
                // 超车次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getOverTakeNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON:
                // 超车次数
                $this->updateTaskSchedule($taskData, $matchOperation->getOverTakeNum());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SKILL_NUM:
                // 技能次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getSkillNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_SKILL_NUM_COMMON:
                // 技能次数
                $this->updateTaskSchedule($taskData, $matchOperation->getSkillNum());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_JAM_SKILL_NUM:
                // 干扰技能次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getJamSkillNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON:
                // 干扰技能次数
                $this->updateTaskSchedule($taskData, $matchOperation->getJamSkillNum());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_HELP_SKILL_NUM:
                // 辅助技能次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getHelpSkillNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON:
                // 辅助技能次数
                $this->updateTaskSchedule($taskData, $matchOperation->getHelpSkillNum());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIVING_RANGE:
                // 行驶距离 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $matchOperation->getDrivingRange());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON:
                // 行驶距离
                $this->updateTaskSchedule($taskData, $matchOperation->getDrivingRange());
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_1_NUM:
                //刹车漂移次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift1Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_1_RANGE:
                //刹车漂移距离 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift1Range());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_2_NUM:
                //直线漂移次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift2Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_2_RANGE:
                //直线漂移距离 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift2Range());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_3_NUM:
                //惯性漂移次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift3Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_3_RANGE:
                //惯性漂移距离 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift3Range());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_QUICK_CURVE_NUM:
                //快速出弯次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getQuickCornesNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_NUM:
                //叠喷次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getNitro1Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_DOUBLE_SPRAY_NUM:
                //小飘双喷次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDoubleJet1Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_NUM:
                //进阶叠喷次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getNitro4Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_LAST_NUM:
                //叠喷延续次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getNitro2Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_LAST_NUM:
                //进阶叠喷延续次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getNitro3Num());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_RESET_NUM:
                //被动重置次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getPassiveResetNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_HIT_NUM:
                //碰撞次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getHitNum());
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_PVP_DRIFT_4_NUM:
                //反向漂移次数 限定模式
                if ($this->checkMatchTypeIsEqual($taskData, $record->matchType)) {
                    $this->updateTaskSchedule($taskData, $taleTarget->getDrift4Num());
                }
                break;
            default:
                return;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    // 检查比赛模式是否一致
    private function checkMatchTypeIsEqual(TaskData $taskData, int $matchType): bool
    {
        $isComp = false;
        foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
            if ($cond[0] == $matchType) {
                $isComp = true;
                break;
            }
        }
        return $isComp;
    }
}
