<?php

/**
 * 任务逻辑管理
 */

namespace Game\Model\Task\Logic;

use Library\Common\Singletons;
use Framework\Log\LogMark;
use Game\Constant\GameErrorCode;
use Game\Constant\TaskLogicDefine;

class TaskLogicManager
{
    use Singletons;

    private array $logicList;   //eventId=>logic

    //根据任务条件,查找对应处理逻辑model
    public function getTaskLogic(int $eventId, int $playerId): ?object
    {
        if (isset($this->logicList[$eventId])) {
            return $this->logicList[$eventId];
        }
        $tld = new TaskLogicDefine();
        $logicName = $tld->getTaskLogicName($eventId);
        if ($logicName == "") {
            LogMark::getInstance()->markError(
                GameErrorCode::TASK_NOT_FOUND_LOGIC,
                "[TaskLogicManage] not found Task Logic",
                array(
                    "eventId" => $eventId
                )
            );
            return null;
        }
        $logic = new $logicName();
        $logic->setPlayerId($playerId);
        $this->logicList[$eventId] = $logic;
        return $logic;
    }
}