<?php

/**
 * 登录天数
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\AccountData;
use Game\Data\TaskData;
use Game\Logic\EventConditionLogic;
use Game\Model\AccountModel;

class TaskLogicLoginDay extends TaskLogicBase
{
    use EventConditionLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //新号初始登录天数,连续登录天数都为1
        $day = array();
        if ($this->isRegister) {
            $day = array(1, 1);
        }
        $this->updateLoginDayTask($taskData, $day);
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数  无
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $this->updateLoginDayTask($taskData, []);
    }

    private function updateLoginDayTask(TaskData $taskData, array $param)
    {
        if (empty($param)) {
            [$loginDay, $loginDay2] = $this->getLoginDay();
        } else {
            [$loginDay, $loginDay2] = $param;
        }
        switch ($taskData->taskConfig[TemplateTask::ConditionType]) {
            case TaskLogicDefine::TASK_CONDITION_LOGIN_DAY:
                //登录天数
                $taskData->schedule = $loginDay;
                $taskData->isChange = true;
                break;
            case TaskLogicDefine::TASK_CONDITION_CONTINUE_LOGIN_DAY:
                //连续登录天数
                $taskData->schedule = $loginDay2;
                $taskData->isChange = true;
                break;
            default:
                return;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function getLoginDay(): array
    {
        /**
         * @var AccountModel $accountModel
         */
        $accountModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        if ($accountModel->search($this->playerId, $playerInfo)) {
            $loginNum = isset($playerInfo[AccountData::DB_LOGIN_NUM]) ?
                (int)$playerInfo[AccountData::DB_LOGIN_NUM] :
                1;
            $loginContinuousNum = isset($playerInfo[AccountData::DB_LOGIN_CONTINUOUS_NUM]) ?
                (int)$playerInfo[AccountData::DB_LOGIN_CONTINUOUS_NUM] :
                1;
            return array($loginNum, $loginContinuousNum);
        }
        return array(1, 1);
    }
}
