<?php

/**
 * 点赞:包含好友列表点赞,对局结束点赞,总计点赞
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TaskLogicDefine;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;
use Game\Model\Friend\FriendIntimacyModel;

class TaskLogicLike extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => num
     *      EVENT_KEY_LIKE_FROM 点赞来源 => EVENT_VALUE_LIKE_FRIEND EVENT_VALUE_LIKE_MATCH
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        // 检查点赞类型
        switch ($taskData->taskConfig[TemplateTask::ConditionType])
        {
            case TaskLogicDefine::TASK_CONDITION_COUNT_LIKE:
                // 总点赞次数
                $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                break;
            case TaskLogicDefine::TASK_CONDITION_FRIEND_LIKE:
                // 好友点赞
                if ($param[GameConstantDefine::EVENT_KEY_LIKE_FROM] == GameConstantDefine::EVENT_VALUE_LIKE_FRIEND) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_LIKE:
                // 对局点赞
                if ($param[GameConstantDefine::EVENT_KEY_LIKE_FROM] == GameConstantDefine::EVENT_VALUE_LIKE_MATCH) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_INTIMACY_FRIEND_LIKE:
                //比赛后,亲密好友点赞
                //检查对方是否是亲密好友
                if ($param[GameConstantDefine::EVENT_KEY_LIKE_FROM] == GameConstantDefine::EVENT_VALUE_LIKE_MATCH &&
                    isset($param[GameConstantDefine::EVENT_VALUE_LIKE_PLAYER_ID]) &&
                    $this->checkTargetIntimacy($param[GameConstantDefine::EVENT_VALUE_LIKE_PLAYER_ID])
                ) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
                  }
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function checkTargetIntimacy(int $targetPlayerId): bool
    {
        //检查是否是AI
        $AI_MIN = $this->getTerm(TemplateDefine::TYPE_CONST, TemplateConst::Const_AI_PlayerID_Min, TemplateConst::ConstNum);
        $AI_MAX = $this->getTerm(TemplateDefine::TYPE_CONST, TemplateConst::Const_AI_PlayerID_Max, TemplateConst::ConstNum);
        if ($targetPlayerId >= $AI_MIN && $targetPlayerId <= $AI_MAX) {
            return false;
        }
        /**
         * @var FriendIntimacyModel $friendIntimacyModel
         */
        $friendIntimacyModel = ModelManager::getInstance()->getModel(ModelTypeDefine::FRIEND_INTIMACY);
        $friendIntimacyModel->setRespondentPlayerId($targetPlayerId);
        return $friendIntimacyModel->checkHasIntimacy();
    }
}
