<?php

/**
 * 参与pvp/pve比赛任务
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\TaskData;

class TaskLogicJoinMatch extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_MATCH_MAP =>
     *      EVENT_KEY_MATCH_TYPE
     *      EVENT_KEY_CAR_ID
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        //支线任务检查
        if ($taskData->taskConfig[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_BRANCH) {
            //检查车Id
            if ($taskData->taskConfig[TemplateTask::GroupType] != $param[GameConstantDefine::EVENT_KEY_CAR_ID]) {
                return;
            }
        }
        //指定地图指定模式进行比赛的次数 模式*地图;...
        if ($taskData->taskConfig[TemplateTask::ConditionType] != TaskLogicDefine::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_MAP) {
            return;
        }
        $isComp = false;
        foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
            if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                if ($cond[1] == 0) {
                    //0为不限制地图
                    $isComp = true;
                    break;
                }
                if ($cond[1] == $param[GameConstantDefine::EVENT_KEY_MATCH_MAP]) {
                    $isComp = true;
                    break;
                }
            }
        }
        if ($isComp) {
            $this->updateTaskSchedule($taskData, 1);
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
