<?php

/**
 * 邀请好友/俱乐部完成比赛
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\TaskData;
use Game\Logic\Friend\FriendLogic;
use Game\Logic\PaiweiLevelLogic;

class TaskLogicInvitedPlayer extends TaskLogicBase
{
    use FriendLogic;
    use PaiweiLevelLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_INVITED_PLAYER => 邀请的玩家[playerId,..]
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        if (count($param[GameConstantDefine::EVENT_KEY_INVITED_PLAYER]) == 0) {
            return;
        }
        switch ($taskData->taskConfig[TemplateTask::ConditionType])
        {
            case TaskLogicDefine::TASK_CONDITION_MATCH_INVITATION_FRIEND:
                // 邀请好友比赛
                $num = $this->getInvitedFriendNum($param[GameConstantDefine::EVENT_KEY_INVITED_PLAYER]);
                if ($num > 0) {
                    // 如果
                    $this->updateTaskSchedule($taskData, $num);
                }
                break;
            default:
                return;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function getInvitedFriendNum(array $playerList): int
    {
        $num = 0;
        foreach ($playerList as $playerId) {
            if ($this->checkTargetPlayerIsMyFriend($playerId)) {
                $num++;
            }
        }
        return $num;
    }
}
