<?php

/**
 * 添加好友
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\TaskData;
use Game\Model\Friend\FriendModel;

class TaskLogicFriendNum extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
        // 检查已有好友数量
        $friendNum = $this->getMyFriendNum();
        if ($friendNum > 0) {
            $this->updateTaskSchedule($taskData, $friendNum);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => 新加好友数量 1
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $num = $param[GameConstantDefine::EVENT_KEY_NUM];
        $this->updateTaskSchedule($taskData, $num);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function getMyFriendNum(): int
    {
        /**
         * @var FriendModel $friend
         */
        $friend = ModelManager::getInstance()->getModel(ModelTypeDefine::FRIEND);
        return $friend->getMineNumber();
    }
}
