<?php

/**
 * 当天登录
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TaskLogicDefine;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Data\TaskData;
use Game\Logic\EventConditionLogic;
use Game\Model\AccountModel;

class TaskLogicDayLogin extends TaskLogicBase
{
    use EventConditionLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        $w = date('w');
        $taskCfg = $this->getTitle(TemplateDefine::TYPE_TASK, $taskData->taskId);
        if($taskCfg[TemplateTask::GroupId] === (int)$w) {
            $this->updateTaskSchedule($taskData, 1);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数  无
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $this->updateLoginWeekTask($taskData, $param);
    }

    private function updateLoginWeekTask(TaskData $taskData, array $param)
    {
        $this->updateTaskSchedule($taskData, 1);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
