<?php

/**
 * 完成PVE关卡,不包含生涯
 */

namespace Game\Model\Task\Logic;

use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\PVE\LevelData;
use Game\Data\TaskData;
use Game\Model\PVE\PveModel;

class TaskLogicCompletePveLevel extends TaskLogicBase
{
    use TemplateHelp;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //新号初始未通关任何pve关卡
        if ($this->isRegister) {
            return;
        }
        //检查关卡类型
        $levelId = $taskData->taskConfig[TemplateTask::Condition];
        $levelType = $this->getTerm(TemplateDefine::TYPE_TALE, $levelId, TemplateTale::Type);
        if (is_null($levelType)) {
            LogMark::getInstance()->markError(
                GameErrorCode::TASK_CONFIG_NOT_FOUND,
                "[TaskLogicCompletePveLevel] not found tale config",
                array(
                    "taskId" => $taskData->taskId,
                    "levelId" => $levelId
                )
            );
            return;
        }
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        switch ($levelType)
        {
            case TemplateTale::TYPE_MAIN:
            case TemplateTale::TYPE_BRANCH:
                //不包含主线
                return;
            case TemplateTale::TYPE_DRIVING_LICENSE_EXAM:
            case TemplateTale::TYPE_DRIVING_PERMIT:
            case TemplateTale::TYPE_TEACHING_SKILL:
                $levelData = $pveModel->getLevelData($levelId);
                if ($levelData->levelId == 0) {
                    //未解锁
                    return;
                }
                break;
            default:
                return;
        }
        //检查是否通关--一次通关
        if ($levelData->status == LevelData::STATUS_DOING) {
            return;
        }
        $this->updateTaskSchedule($taskData, 1);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    public function updateTask(TaskData $taskData, array $param)
    {
        //检查关卡Id
        if ($taskData->taskConfig[TemplateTask::Condition] != $param[GameConstantDefine::EVENT_KEY_PVE_LEVEL_ID]) {
            return;
        }
        $this->updateTaskSchedule($taskData, 1);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
