<?php

/**
 * 完成pvp比赛
 * 有关比赛时间,地图,模式的任务
 */

namespace Game\Model\Task\Logic;

use Framework\Lib\Utils;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\TaskData;

class TaskLogicCompleteMatch extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_MATCH_TIME => 比赛时间
     *      EVENT_KEY_MATCH_MAP
     *      EVENT_KEY_MATCH_TYPE => 比赛模式(匹配/排位)
     *      EVENT_KEY_CAR_ID
     *      EVENT_KEY_MATCH_WIN => 比赛胜负标志
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        //支线任务检查
        if ($taskData->taskConfig[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_BRANCH) {
            //检查车Id
            if ($taskData->taskConfig[TemplateTask::GroupType] != $param[GameConstantDefine::EVENT_KEY_CAR_ID]) {
                return;
            }
        }
        switch ($taskData->taskConfig[TemplateTask::ConditionType])
        {
            case TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_NUM:
                // 完成比赛,时间必须大于0
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_TIME] > 0) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_WIN_NUM:
                //指定模式地图胜利次数(个人赛胜利为前3名,团队赛胜利为队伍胜利)
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_WIN]) {
                    $isComp = false;
                    foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                        if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                            if ($cond[1] == 0) {
                                // 地图=0为不限地图
                                $isComp = true;
                                break;
                            }
                            if ($cond[1] == $param[GameConstantDefine::EVENT_KEY_MATCH_MAP]) {
                                $isComp = true;
                                break;
                            }
                        }
                    }
                    if ($isComp) {
                        $this->updateTaskSchedule($taskData, 1);
                    }
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_MVP:
                // 获得mvp
                if ($param[GameConstantDefine::EVENT_KEY_MVP]) {
                    $isComp = false;
                    foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                        if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                            if ($cond[1] == 0) {
                                // 地图=0为不限地图
                                $isComp = true;
                                break;
                            }
                            if ($cond[1] == $param[GameConstantDefine::EVENT_KEY_MATCH_MAP]) {
                                $isComp = true;
                                break;
                            }
                        }
                    }
                    if ($isComp) {
                        $this->updateTaskSchedule($taskData, 1);
                    }
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_WITH_TYPE_MAP:
                // 指定地图进行指定模式对局冲过终点的次数 模式*地图;...
                $isComp = false;
                foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                    if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                        if ($cond[1] == 0) {
                            // 地图=0为不限地图
                            $isComp = true;
                            break;
                        }
                        if ($cond[1] == $param[GameConstantDefine::EVENT_KEY_MATCH_MAP]) {
                            $isComp = true;
                            break;
                        }
                    }
                }
                if ($isComp) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_TIME_WITH_TYPE_MAP:
                //指定地图指定模式冲线时间 模式*地图;...
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_TIME] <= 0) {
                    return;
                }
                $isComp = false;
                foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                    if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                        if ($cond[1] == 0) {
                            // 地图=0为不限地图
                            $isComp = true;
                            break;
                        }
                        if ($cond[1] == $param[GameConstantDefine::EVENT_KEY_MATCH_MAP]) {
                            $isComp = true;
                            break;
                        }
                    }
                }
                if ($isComp) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_MATCH_TIME]);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_TIME:
                //指定完成时间
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_TIME] > 0) {
                    $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_MATCH_TIME]);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_REALTIME:
                //指定模式指定时间(真实时间)完成比赛的次数
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_TIME] <= 0) {
                    return;
                }
                $isComp = false;
                $nowTime = (int)date("Hi", Utils::getServerTimestamp());
                foreach ($taskData->taskConfig[TemplateTask::Condition] as $cond) {
                    if ($cond[0] == $param[GameConstantDefine::EVENT_KEY_MATCH_TYPE]) {
                        $timeConfig = explode("-", $cond[1]);
                        if (count($timeConfig) != 2) {
                            return;
                        }
                        [$startTime, $endTime] = $timeConfig;
                        //检查时间范围
                        if ($nowTime >= (int)$startTime && $nowTime <= (int)$endTime) {
                            $isComp = true;
                            break;
                        }
                    }
                }
                if ($isComp) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            case TaskLogicDefine::TASK_CONDITION_MATCH_ICON:
                // 获得徽章
                $configIconId = $taskData->taskConfig[TemplateTask::Condition];
                if (isset(
                        GameConstantDefine::PVP_TIPS_2_ICON[$configIconId],
                        $param[GameConstantDefine::PVP_TIPS_2_ICON[$configIconId]]
                    ) &&
                    $param[GameConstantDefine::PVP_TIPS_2_ICON[$configIconId]]
                ) {
                    $this->updateTaskSchedule($taskData, 1);
                }
                break;
            default:
                return;
        }
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
