<?php

/**
 * 完成任务次数
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\TaskData;

class TaskLogicCompTaskNum extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_COMP_TASK_TYPE => [完成任务类型=>数量]
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $condition = $taskData->taskConfig[TemplateTask::Condition];
        if (array_key_exists($condition, $param[GameConstantDefine::EVENT_KEY_COMP_TASK_TYPE])) {
            $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_COMP_TASK_TYPE][$condition]);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }
}
