<?php

/**
 * 通用型任务 每次触发增加进度,初始检查不依赖其他
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\TaskData;

class TaskLogicCommon extends TaskLogicBase
{

    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => num
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        if (!isset($param[GameConstantDefine::EVENT_KEY_NUM])) {
            return;
        }
        $num = $param[GameConstantDefine::EVENT_KEY_NUM];
        $this->updateTaskSchedule($taskData, $num);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
