<?php

/**
 * 生涯章节获得星数
 */

namespace Game\Model\Task\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\TaskData;
use Game\Model\PVE\PveModel;

class TaskLogicCareerLevelStar extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //新建用户,生涯没有星
        if ($this->isRegister) {
            return;
        }
        $starNum = $this->getLevelStar($taskData->taskConfig[TemplateTask::Condition]);
        if ($starNum > 0) {
            $this->updateTaskSchedule($taskData, $starNum);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }

    public function updateTask(TaskData $taskData, array $param)
    {
        //检查章节
        if ($taskData->taskConfig[TemplateTask::Condition] != $param[GameConstantDefine::EVENT_KEY_PVE_LEVEL_ID]) {
            return;
        }
        $star = $param[GameConstantDefine::EVENT_KEY_NUM];
        $this->updateTaskSchedule($taskData, $star);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function getLevelStar(int $levelId): int
    {
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $levelData = $pveModel->getCareerLevelData($levelId);
        if ($levelData->levelId == 0) {
            return 0;
        }
        return $levelData->starNum;
    }
}
