<?php

/**
 * 车辆改造/外观改装
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Constant\TaskLogicDefine;
use Game\Data\Car\CarDeepmodData;
use Game\Data\TaskData;
use Game\Logic\EventConditionLogic;

class TaskLogicCarRefit extends TaskLogicBase
{
    use EventConditionLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //新号初始没有改装次数
        if ($this->isRegister) {
            return;
        }
        //车辆改造需要记录初始值,限时的任务不需要
        if ($taskData->taskConfig[TemplateTask::ConditionType] == TaskLogicDefine::TASK_CONDITION_CAR_REFIT) {
            $conditionList = $taskData->taskConfig[TemplateTask::Condition][0];
            $num = $this->getCarRefitNum($conditionList[0], $conditionList[1]);
            if ($num > 0) {
                $this->updateTaskSchedule($taskData, $num);
                if ($this->checkIsDone($taskData)) {
                    $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                    $taskData->status = TaskData::STATUS_DONE;
                }
            }
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_NUM => 强化次数 1
     *      EVENT_KEY_CAR_ID=>CarTplId
     *      EVENT_KEY_CAR_REFIT_SYS_ID => 赛车改造/外观改装类型Id
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        // 检查
        //改造条件 赛车ID*（改造动力=1 改造NOS=2 改造车体倒流=3, 0不限位置）
        //外观改装 赛车ID*（改装类型 1-9)
        $conditionList = $taskData->taskConfig[TemplateTask::Condition][0];
        $isComp = true;
        // 车辆Id
        if ($conditionList[0] != 0 && $conditionList[0] != $param[GameConstantDefine::EVENT_KEY_CAR_ID]) {
            $isComp = false;
        }
        // 系统Id
        if ($conditionList[1] != 0 && $conditionList[1] != $param[GameConstantDefine::EVENT_KEY_CAR_REFIT_SYS_ID]) {
            $isComp = false;
        }
        if ($isComp) {
            $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }

    //查询车改造次数
    //sys为改造位置 0为全部位置
    private function getCarRefitNum(int $carId, int $sys): int
    {
        if ($sys == 0) {
            //查询全部部位
            $keyList = array();
            foreach (CarDeepmodData::DB_SYS_TYPE as $key => $value) {
                $keyList[] = $this->getCarRefitKey($carId, $key);
            }
            $result = $this->getMultiEventConditionValue($keyList);
            return array_sum(array_values($result));
        }
        return $this->getSingleEventConditionValue($this->getCarRefitKey($carId, $sys));
    }
}
