<?php

/**
 * 指定车提升熟练度到指定等级
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\TaskData;
use Game\Logic\CarLogic;

class TaskLogicCarProficiency extends TaskLogicBase
{
    use CarLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //检查已有熟练度等级
        $carId = $this->getNeedCarId($taskData->taskConfig);
        $carProficiencyLv = 0;
        if ($this->isRegister) {
            //新号初始车熟练度等级1
            $carProficiencyLv = 1;
        } else {
            $carData = $this->searchCarDataByCarID($carId);
            if (!is_null($carData)) {
                $carProficiencyLv = $carData->proficiencyLv;
            }
        }
        $this->updateTaskSchedule($taskData, $carProficiencyLv);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_CAR_ID=>CarTplId
     *      EVENT_KEY_NUM => 增加等级
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        //检查是否要求指定赛车
        $needCarId = $this->getNeedCarId($taskData->taskConfig);
        if ($needCarId != 0 && $needCarId != $param[GameConstantDefine::EVENT_KEY_CAR_ID]) {
            return;
        }
        $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    private function getNeedCarId(array $taskConfig): int
    {
        return $taskConfig[TemplateTask::Condition];
    }
}
