<?php

/**
 * 购买商城道具
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\TaskData;

class TaskLogicBuyShopItem extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_ITEM_ID => 道具Id
     *      EVENT_KEY_NUM
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        //itemId 是Item表id
        $configItemId = $taskData->taskConfig[TemplateTask::Condition];
        if ($configItemId == 0 ||
            $param[GameConstantDefine::EVENT_KEY_ITEM_ID] == $configItemId) {
            //configItemId=0 不限道具
            $this->updateTaskSchedule($taskData, $param[GameConstantDefine::EVENT_KEY_NUM]);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }
}
