<?php

/**
 * 支线任务主任务
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameConstantDefine;
use Game\Data\TaskData;

class TaskLogicBranchMain extends TaskLogicBase
{
    public function getDefaultValue(TaskData $taskData, array $param)
    {
        //初始进度为0
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数
     *      EVENT_KEY_TASK_ID => 子任务id
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        if (!isset($param[GameConstantDefine::EVENT_KEY_TASK_ID])) {
            return;
        }
        $taskId = $param[GameConstantDefine::EVENT_KEY_TASK_ID];
        $tarTaskConfig = $this->getTaskConfigByTaskId($taskId);
        if (is_null($tarTaskConfig)) {
            return;
        }
        if ($tarTaskConfig[TemplateTask::GroupType] == 0) {
            return;
        }
        //检查触发的任务和主任务类型是否一致
        if ($taskData->taskConfig[TemplateTask::TaskType] == $tarTaskConfig[TemplateTask::TaskType] &&
            $taskData->taskConfig[TemplateTask::GroupType] == $tarTaskConfig[TemplateTask::GroupType] &&
            $taskData->taskConfig[TemplateTask::GroupId] == $tarTaskConfig[TemplateTask::GroupId]
        ) {
            $this->updateTaskSchedule($taskData, 1);
            if ($this->checkIsDone($taskData)) {
                $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
                $taskData->status = TaskData::STATUS_DONE;
            }
        }
    }
}
