<?php

/**
 * 活跃度
 */

namespace Game\Model\Task;

use Framework\Logic\TemplateHelp;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateDailyReward;
use Game\Constant\TemplateDefine;
use Game\Data\ActiveData;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\GCDailyInfo;
use Game\Protobuf\PacketId;

class ActiveModel
{
    use TemplateHelp;
    use ClubLogic;

    private int $playerId;
    private ?ActiveData $activeData = null;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function onRegister()
    {
        $this->activeData = new ActiveData($this->playerId);
        $this->activeData->initActive();
        $this->activeData->registerDB();
    }

    public function reset()
    {
        $this->init();
        $this->activeData->initActive();
        $this->activeData->updateDB();
    }

    public function getActiveData(): ActiveData
    {
        $this->init();
        return $this->activeData;
    }

    public function resetRefreshNum()
    {
        $this->init();
        $this->activeData->resetRefreshNum();
    }

    public function addActivePoint(int $num): ActiveData
    {
        $this->init();
        $this->activeData->addActivePoint($num);
        $this->activeData->updateDB();
        // 更新俱乐部活跃度
        $this->upActivity($num);
        return $this->activeData;
    }

    public function setActiveId(int $id): ActiveData
    {
        $this->init();
        $this->activeData->setActiveId($id);
        $this->activeData->updateDB();
        return $this->activeData;
    }

    //获取活跃度等级
    public function getActiveLv(int $num): int
    {
        $dailyRewardConfig = $this->getTable(TemplateDefine::TYPE_DAILY_TASK_REWARD);
        $lv = 0;
        foreach ($dailyRewardConfig as $id => $info) {
            if ($info[TemplateDailyReward::TaskType] == TemplateDailyReward::TASK_TYPE_1 && $num >= $info[TemplateDailyReward::Vitality]) {
                $lv = $id;
            }
        }
        return $lv;
    }

    public function getActiveReward(int $start, int $end): array
    {
        $dailyRewardConfig = $this->getTable(TemplateDefine::TYPE_DAILY_TASK_REWARD);
        $reward = array();
        for ($i = $start + 1; $i <= $end; $i++) {
            $temReward = $dailyRewardConfig[$i][TemplateDailyReward::ItemReward];
            foreach ($temReward as $itemId => $num) {
                isset($reward[$itemId]) ? $reward[$itemId] += $num : $reward[$itemId] = $num;
            }
        }
        return $reward;
    }

    public function getActiveMaxLv(): int
    {
        $dailyRewardConfig = $this->getTable(TemplateDefine::TYPE_DAILY_TASK_REWARD);
        $lv = 0;
        foreach ($dailyRewardConfig as $id => $info) {
            if ($info[TemplateDailyReward::TaskType] == TemplateDailyReward::TASK_TYPE_1) {
                $lv++;
            }
        }
        return $lv;
    }

    private function init()
    {
        if (is_null($this->activeData)) {
            $this->activeData = new ActiveData($this->playerId);
            if (false == $this->activeData->searchDB()) {
                $this->activeData->initActive();
                $this->activeData->createDB();
            }
        }
    }

    //获取活跃度信息
    public function sendActiveMessage()
    {
        $activeData = $this->getActiveData();
        $sendMessage = new GCDailyInfo();
        $sendMessage->setAPNum($activeData->activePoint);
        $sendMessage->setAPId($activeData->activeId);
        $sendMessage->setRefreshNum($activeData->refreshNum);
        SendMessage::getInstance()->sendClient(PacketId::GC_DailyInfo, $sendMessage);
    }
}
