<?php

/**
 * 任务兑换商城
 */

namespace Game\Model\Shop;

use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateShopExchange;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\GameErrorCode;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Data\Shop\ShopTaskExchangeData;
use Game\Protobuf\ShopItem;
use Game\Logic\AccountLogic;

class ShopTaskExchangeModel
{
    use TemplateHelp;
    use AccountLogic;

    private int $playerId;
    private array $sendShopItem = array();


    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //获取商城道具
    public function getShopItem($taskID): array
    {
        $shopTaskData = new ShopTaskExchangeData($this->playerId);
        $shopItem = $shopTaskData->searchDB($taskID);
        if (empty($shopItem)) {
            return $this->initShopItem($taskID);
        }
        return $shopItem;
    }

    //初始化任务兑换商城
    private function initShopItem($taskID): array
    {
        $ShopConfig = $this->getTitle(TemplateDefine::TYPE_TASK_EXCHANGE, $taskID);
        foreach ($ShopConfig[TemplateTaskExchange::TaskId] as $itemId) {
            $shopItem[$itemId] = 0;
        }
        $shopTaskData = new ShopTaskExchangeData($this->playerId);
        if (false == $shopTaskData->updateDB($taskID, $shopItem)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                "[ShopTaskExchangeModel] init shop data error",
                $shopItem
            );
            return array();
        }
        return $shopItem;
    }

    //重置每日限购
    public function resetShopLimit($taskID)
    {
        $shopData = new ShopTaskExchangeData($this->playerId);
        $shopItem = $shopData->searchDB($taskID);
        if (empty($shopItem)) {
            $this->initShopItem($taskID);
            return;
        }
        $shopConfig = $this->getTitle(TemplateDefine::TYPE_TASK_EXCHANGE, $taskID);
        if (is_null($shopConfig)) {
            LogMark::getInstance()->markError(
                GameErrorCode::SHOP_CONFIG_NOT_FOUND,
                "[ShopTaskExchangeModel] not found shop item",
            );
            return;
        }
        foreach ($shopConfig[TemplateTaskExchange::TaskId] as $shopID) {
            $exShop = $this->getTitle(TemplateDefine::TYPE_SHOP_EXCHANGE, $shopID);
            switch($exShop[TemplateShopExchange::Term]) {
                case TemplateShopExchange::DAY_RESET:
                    $shopItem[$shopID] = 0;
                    break;
                case TemplateShopExchange::WEEK_RESET:
                    // 检测跨周
                    $loginTime = $this->getAccountAttribute(AccountData::DB_LOGIN_TIME);
                    if(self::checkTaskExchangeIsCrossWeek($loginTime)) {
                        $shopItem[$shopID] = 0;
                    }
                    break;
            }
        }
        $shopData->updateDB($taskID, $shopItem);
    }

    public function addSendShopItem(array $shopItem)
    {
        foreach ($shopItem as $key => $value) {
            if (is_numeric($key)) {
                $sItem = new ShopItem();
                $sItem->setId($key);
                $sItem->setBuyNum($value);
                $this->sendShopItem[] = $sItem;
            }
        }
    }

//    //获取已购买数量
//    public function getHasBuyNum(int $id): int
//    {
//        $shopItem = $this->getShopItem($id);
//        return $shopItem[$id] ?? 0;
//    }

    //更新购买数量
    public function updateBuyNum($taskID, array $data): bool
    {
        if (empty($data)) {
            return true;
        }
        return (new ShopTaskExchangeData($this->playerId))->updateDB($taskID, $data);
    }

    public function getSendShopItem(): array
    {
        return $this->sendShopItem;
    }

    //检查是否跨周 true跨周
    public static function checkTaskExchangeIsCrossWeek(int $time): bool
    {
        if ($time == 0) {
            return false;
        }
        $week = date("W", $time);
        $nowWeek = date("W");
        return $week !== $nowWeek;
    }
}
