<?php

/**
 * 抽奖商城
 */

namespace Game\Model\Shop;

use Game\Data\Shop\ShopBlindBoxData;

class ShopBlindBoxModel
{
    private int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //获取抽奖次数
    public function getDrawNum(int $id): int
    {
        $shopBlindBoxData = new ShopBlindBoxData($this->playerId);
        $result = $shopBlindBoxData->searchDB();
        return $result[$id] ?? 0;
    }

    //获取抽奖数据
    public function getDrawData(): array
    {
        return (new ShopBlindBoxData($this->playerId))->searchDB();
    }

    //更新抽奖次数
    public function updateDrawNum(array $data)
    {
        $shopBlindBoxData = new ShopBlindBoxData($this->playerId);
        $shopBlindBoxData->updateDB($data);
    }
}
