<?php

/**
 * 玩家赛季状态
 */

namespace Game\Model\Season;

use Framework\Logic\CommonDataLogic;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Logic\PaiweiLevelLogic;
use Game\Protobuf\GCUpdateSeason;
use Game\Protobuf\PacketId;

class SeasonStatusModel
{
    use CommonDataLogic;
    use PaiweiLevelLogic;

    public int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    /**
     * 更新赛季状态
     * @param int $myIndex  玩家当前状态
     * @param int $commonIndex  当前赛季状态
     */
    public function syncCommonData(int $myIndex, int $commonIndex)
    {
        if ($myIndex == $commonIndex) {
            return;
        }
        $seasonId = $this->getCommonValueByModel(ModelTypeDefine::SEASON);
        $paiWeiData = $this->getPaiweiLevel();
        //通知赛季更新
        $message = new GCUpdateSeason();
        $message->setSeasonId($seasonId);
        $message->setSeasonStatus($commonIndex);
        $message->setLevelId($paiWeiData->levelId);
        $message->setScore($paiWeiData->score);
        $message->setMaxLevelId($paiWeiData->maxLevelId);
        $message->setGuardScore($paiWeiData->guardScore);
        SendMessage::getInstance()->sendClient(PacketId::GC_UpdateSeason, $message);
    }
}
