<?php

/**
 * 赛季
 */

namespace Game\Model\Season;

use Framework\Log\LogMark;
use Game\Logic\SeasonLogic;

class SeasonModel
{
    use SeasonLogic;

    private int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //赛季更新 检查重置  params: 当前赛季 新赛季
    public function syncCommonData(int $myIndex, int $commonIndex)
    {
        if ($this->playerId == 0) {
            return;
        }
        if ($myIndex == 0) {
            //新号 不需要重置
            return;
        }
        if ($myIndex >= $commonIndex) {
            return;
        }

        // TODO: 把 myIndex 排位数据清除

        LogMark::getInstance()->markDebug(
            "[SeasonModel] season change,Reset seasonData",
            array(
                "oldSeasonId" => $myIndex,
                "newSeasonId" => $commonIndex
            )
        );
        $this->resetSeasonData($commonIndex);

        // TODO: 清除上个赛季玩家排行榜信息  暂时不清除数据 防止后续有历史排行榜需求

    }
}