<?php

/**
 * 比赛记录
 */

namespace Game\Model;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\TemplateDefine;
use Game\Data\RecordCollectionData;
use Game\Data\RecordData;

class RecordModel
{
    use PlayerDBHandler;
    use TemplateHelp;

    public int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //更新比赛记录
    public function updateRecordData(int $joinId, array $data, bool $delTop = false)
    {
        $record = new RecordData($this->playerId, $joinId);
        $record->saveDB($data);
        if ($delTop) {
            $this->delTopRecord();
        }
    }

    //检查并删除超上限记录
    public function checkDelTopRecord()
    {
        $this->delTopRecord();
    }

    //获取比赛记录
    public function getRecordByJoinId(int $joinId, int $playerID = 0): ?RecordData
    {
        if($playerID == 0) {
            $playerID = $this->playerId;
        }
        if ($joinId == 0) {
            return null;
        }
        $record = new RecordData($playerID, $joinId);
        if ($record->getRecordData()) {
            return $record;
        }
        return null;
    }

    public function getAllRecordUid(int $start, int $stop): array
    {
        $result = array();
        if(!$this->searchRankByIndex(DBTableDefine::TABLE_RECORD, $this->playerId, $start, $stop, $result)) {
            return array();
        }
        return array_keys($result);
    }

    //删除超过上限记录
    private function delTopRecord()
    {
        $result = 0;
        $this->searchRankNum(DBTableDefine::TABLE_RECORD, $this->playerId , $result);
        $hasNum = (int)$result;
        $collectionNum = $this->getCollectionNum();
        $configMaxNum = $this->getTerm(TemplateDefine::TYPE_CONST,
                                           TemplateConst::Const_Record_Max,
                                           TemplateConst::ConstNum);
        if ($hasNum - $collectionNum > $configMaxNum) {
            $recordList = $this->getAllRecordUid($configMaxNum, -1);
            $collectionIds = $this->getAllCollection();
            foreach ($recordList as $joinId) {
                if (in_array($joinId, $collectionIds)) {
                    continue;
                }
                $this->delRecordByJoinId($joinId);
            }
        }
    }

    public function delRecordByJoinId(int $joinId): bool
    {
        return (new RecordData($this->playerId, $joinId))->delRecord();
    }

    //---------比赛记录收藏------------
    //获取全部收藏记录id
    public function getAllCollection(): array
    {
        return (new RecordCollectionData($this->playerId))->getAllCollectionIds(0, -1);
    }

    //获取收藏数量
    public function getCollectionNum(): int
    {
        return (new RecordCollectionData($this->playerId))->getRecordCollectionNum();
    }

    //检查是否已收藏
    public function checkHasCollection(int $joinId): bool
    {
        return (new RecordCollectionData($this->playerId))->checkHasCollection($joinId);
    }

    //添加收藏
    public function addCollection(int $joinId): bool
    {
        return (new RecordCollectionData($this->playerId))->addRecordCollection($joinId);
    }

    //取消收藏
    public function removeCollection(int $joinId): bool
    {
        return (new RecordCollectionData($this->playerId))->removeRecordCollection($joinId);
    }
}
