<?php
/**
 * 匹配消息处理
 */
namespace Game\Model\Pvp;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\JoinIdData;
use Game\Data\PvpPacket\PvpMsgData;
use Game\Data\RecordData;
use Game\GameLive;
use Game\Logic\CarLogic;
use Game\Logic\PaiweiLevelLogic;
use Game\Logic\Pvp\PvpLogic;
use Game\Model\RoomCustomizeModel;
use Game\Operation\EventLog\StartPVPLog;
use Game\Operation\EventLog\EventLog_Manager;
use Game\Operation\EventLog\EventLogType;
use Google\Protobuf\Internal\Message;

class PacketMatchingResultToPlayer
{
    use PvpLogic;
    use CarLogic;
    use PaiweiLevelLogic;

    public int $playerId;
    private ?JoinIdData $jd = null;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //处理数据 返回匹配信息
    public function dealMatchingResult(array $msgData, array $playerData, int $matchUID): bool
    {
        $matchType = $msgData[PvpMsgData::MATCH_TYPE];
        $modeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::MODE_MAP[$matchType]);
        $modeModel->setPlayerId($this->playerId);

        LogMark::getInstance()->markInfo(
            "[PVPFlowLog][10][PvpPack] dealMatchingResult"
        );

        if(!$modeModel->pvpMatchingRecv($msgData)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                "[PVPFlowLog][PacketMatchingResultToPlayer] pvp matching recv exec error!"
            );
            return false;
        }

        //排除观战玩家
        if($playerData[PvpMsgData::ROLE_TYPE] == RoomCustomizeModel::WATCH_ROOM) {
            return true;
        }

        $this->jd = new JoinIdData($this->playerId);
        $this->jd->searchDB();

        //记录匹配信息
        $this->jd->status = GameConstantDefine::PLAYER_STATUS_GAMING;
        $this->jd->saveJoinId();
        $this->syncFriendStatusToAll($this->jd->status, $this->jd->playerId);
        $changeData = array(
            RecordData::MATCH_UID => $matchUID,
            RecordData::MAP_ID => $msgData[PvpMsgData::MAP_ID],
        );
        $this->updateRecordData($this->playerId, $this->jd->joinId, $changeData);
        //触发任务
        $param = array(
            GameConstantDefine::EVENT_KEY_MATCH_MAP => $msgData[PvpMsgData::MAP_ID],
            GameConstantDefine::EVENT_KEY_MATCH_TYPE => $matchType,
            GameConstantDefine::EVENT_KEY_CAR_ID => $playerData[PvpMsgData::CAR_SHOW]->getCarTplID(),
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_JOIN_MATCH, $param, false);
        //记录车使用次数
        $this->recordCarUseNum($param[GameConstantDefine::EVENT_KEY_CAR_ID]);
        //记录打点日志
        GameLive::getInstance()->InitProtagonistPlayerId($this->playerId);
        $log = EventLog_Manager::getInstance()->getEventLog(EventLogType::StartPVP);
        if (!is_null($log)) {
            EventLog_Manager::getInstance()->cliInitAccount();
            /**
             * @var StartPVPLog $log
             */
            $log->matchType = $matchType;
            $log->matchUid = $matchUID;
            $log->playerCarId = $playerData[PvpMsgData::CAR_SHOW]->getCarTplID();
            $log->playerCarProficiencyLv = $playerData[PvpMsgData::CAR_SHOW]->getProficiencyLv();
            $log->playerNum = count($msgData[PvpMsgData::PLAYER_LIST]);
            $log->playerJoinId = $this->jd->joinId;
            $log->mapId = $msgData[PvpMsgData::MAP_ID];
            $log->playerDan = $this->getPaiweiLevel()->levelId;
            $carData = $this->searchCarDataByCarID($playerData[PvpMsgData::CAR_SHOW]->getCarTplID());
            if (is_null($carData)) {
                $log->playerCarPerformance = 0;
                $log->playerCarLv = 0;
            } else {
                $log->playerCarPerformance = $carData->performance;
                $log->playerCarLv = $carData->level;
            }
            $log->markLog();
        }
        return true;
    }
}