<?php

/**
 * 总熟练度
 */

namespace Game\Model;

use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Game\Data\ProficiencyData;

class ProficiencyModel
{
    use TemplateHelp;

    public int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //获取总熟练度信息
    public function getTotalProficiencyData(): ProficiencyData
    {
        $proficiencyData = new ProficiencyData($this->playerId);
        if (false == $proficiencyData->searchDB()) {
            LogMark::getInstance()->markDebug(
                "[ProficiencyModel] search Proficiency date error",
                array(
                    "playerId" => $this->playerId
                )
            );
            $proficiencyData->initProficiencyData();
        }
        return $proficiencyData;
    }
}
