<?php
/**
 * 在线通知模块
 * @date 2022-4-18
 * @author JZW
 **/


namespace Game\Model;


use Game\Constant\ClientErrorCode;
use Game\Data\NoticeData;

class NoticeModel
{
    private NoticeData $data;

    private int $playerId = 0;
    private int $otherPlayerId = 0;
    public int $dbIndex = 0; //

    public function __construct()
    {
        $this->data = new NoticeData();
    }

    /**
     * @param int $playerId
     */
    public function setPlayerId(int $playerId): void
    {
        $this->playerId = $playerId;
    }

    /**
     * @param int $playerId
     */
    public function setOtherPlayerId(int $playerId): void
    {
        $this->otherPlayerId = $playerId;
    }

    //清除通知数据
    public function clearNotice(): bool
    {
        foreach (NoticeData::saveDBIndex as $title){
            $this->data->playerId = $this->playerId;
            $this->data->dbTitle = $title;
            $this->data->clearNotice();
        }
        return true;
    }

    //添加消息
    public function addNotice(int $title): bool
    {
        $this->data->dbTitle = $title;
        $this->data->playerId = $this->playerId;
        $this->data->otherPlayerId = $this->otherPlayerId;
        if (!$this->data->addNotice()){
            return false;
        }
        return true;
    }

    //查询消息数量
    public function getNoticeNum(int $playerId, int $title): int
    {
        $this->data->playerId = $playerId;
        $this->data->dbTitle = $title;
        return $this->data->getNoticeNum();
    }

    //删除通知
    public function delNotice(): bool
    {
        $this->data->dbTitle = $this->dbIndex;
        $this->data->playerId = $this->playerId;
        $this->data->otherPlayerId = $this->otherPlayerId;
        return $this->data->delNotice();
    }
}