<?php

/**
 * 地图结算统计数据
 */

namespace Game\Model;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplatePVPMap;
use Game\Constant\TemplateDefine;
use Game\Data\MapStatisticsData;

class MapStatisticsModel
{
    use TemplateHelp;

    public int $playerId;

    public const TITLE_HISTORY = 0; //历史记录
    public const TITLE_WEEK = 1;    //周记录
    public const TITLE_MONTH = 2;   //月记录

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //获取记录
    public function getMapStatisticsData(int $mapId, int $titleType): MapStatisticsData
    {
        $data = new MapStatisticsData($this->playerId, $mapId, $titleType);
        $data->searchDB();
        return $data;
    }

    //更新记录数据
    public function updateMapStatisticsData(MapStatisticsData $data)
    {
        $data->updateDB();
    }

    //跨周 月 清空数据
    public function clearMapStatisticsDataByTitleType(int $titleType)
    {
        $mapConfig = $this->getTitle(TemplateDefine::TYPE_PVP_MAP, 0);
        foreach ($mapConfig as $mapId) {
            if ($mapId == TemplatePVPMap::RANDOM_MAP_ID) {
                continue;
            }
            $data = new MapStatisticsData($this->playerId, $mapId, $titleType);
            $data->clearTable();
        }
    }
}
