<?php
/**
 * 比赛后点赞
 * @date 2022/6/14/014
 * @author JZW
 **/

namespace Game\Model;


use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Data\Likes\RankData;
use Game\Logic\EventLogic;
use Game\Logic\Friend\FriendLogic;

class LikesModel
{
    use EventLogic;
    use FriendLogic;

    private RankData $rankData;
    public int $playerId;
    public int $otherId;
    public int $matchId;
    public int $errorCode = 0;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function __construct()
    {
        $this->rankData = new RankData();
    }

    public function addRankLikes(): bool
    {
        $this->rankData->playerId = $this->playerId;
        $this->rankData->matchId = $this->matchId;
        $this->rankData->otherId = $this->otherId;
        if (!$this->rankData->addLikes()){
            $this->errorCode = $this->rankData->errorCode;
            return false;
        }
        // 触发任务
        $param = array(
            GameConstantDefine::EVENT_KEY_NUM => 1,  //点赞次数
            GameConstantDefine::EVENT_KEY_LIKE_FROM => GameConstantDefine::EVENT_VALUE_LIKE_MATCH,
            GameConstantDefine::EVENT_VALUE_LIKE_PLAYER_ID => $this->otherId,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE, $param);
        //点赞 增加亲密度
        $point = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Intimacy_Add_Point_Like,
            TemplateConst::ConstNum);
        $this->addFriendIntimacy($this->otherId, $point, GameConstantDefine::INTIMACY_SOURCE_LIKE);
        return true;
    }

    public function getLikesNum(): int
    {
        $this->rankData->otherId = $this->otherId;
        $this->rankData->matchId = $this->matchId;
        return count($this->rankData->getLikes());
    }
}