<?php

/**
 *  跑马灯
 *
 */
namespace Game\Model;

use Framework\Logic\CommonDataLogic;
use Game\Constant\DBTableDefine;
use Game\Logic\AccountLogic;
use Framework\DB\Handler\CommonDBHandler;
use Game\Protobuf\GCLampNoticeInfo;
use Game\Protobuf\GMLampAdd;
use Game\Protobuf\MGLampAdd;
use Game\Protobuf\PacketId;
use Framework\Lib\Utils;
class LampModel
{
    use CommonDataLogic;
    use AccountLogic;
    use CommonDBHandler;

    public int $playerId;

    public function setPlayerId($playerId): void
    {
        $this->playerId = $playerId;
    }

    //同步系统跑马灯
    public function syncCommonData(int $myIndex, int $commonIndex)
    {
        if ($myIndex >= $commonIndex) {
            return;
        }

        // 读取数据给客户端返回
        $this->searchTermMultiCommon($ret, DBTableDefine::TABLE_LAMP, 0, [$commonIndex]);

        $lampMsg = new MGLampAdd();
        $strMsg = base64_decode($ret[$commonIndex]);
        $lampMsg->mergeFromString($strMsg);
        $timeEnd = $lampMsg->getTimeEnd();
        $num = $lampMsg->getNum();

        // 撤销的跑马灯不发送
        if(empty($num)) {
            return ;
        }

        // 过期的跑马灯不发送
        if(empty($timeEnd) || $timeEnd <= Utils::getServerTimestamp()) {
            return ;
        }

        $sendMsg = new GCLampNoticeInfo();
        $sendMsg->setID($lampMsg->getID());
        $sendMsg->setNum($num);
        $sendMsg->setContent($lampMsg->getContent());
        $this->addPacket(PacketId::GC_LampNoticeInfo, $sendMsg, $this->playerId);
    }
}
