<?php
/**
 * 陌生人黑名单
 * @date 2022-4-19
 * @author JZW
 **/


namespace Game\Model\Friend;


use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\TemplateDefine;
use Game\Data\Friends\FriendsData;
use Game\Data\Friends\StrangerBlackData;

class StrangerBlackModel
{
    use TemplateHelp;

    private int $playerId;
    private int $respondentPlayerId;
    private StrangerBlackData $black;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setRespondentPlayerId($respondentPlayerId)
    {
        $this->respondentPlayerId = $respondentPlayerId;
    }

    public function __construct()
    {
        $this->black = new StrangerBlackData();
    }

    //添加陌生人到黑名单
    public function addBlack(): bool
    {
        $this->black->playerId = $this->playerId;
        $this->black->respondentPlayerId = $this->respondentPlayerId;
        return $this->black->saveDB();
    }
    //删除黑名单上的好友
    public function delBlack(&$ret): bool
    {
        $this->black->playerId = $this->playerId;
        $this->black->respondentPlayerId = $this->respondentPlayerId;
        return $this->black->deleteDB($ret);
    }

    public function searchList(): array
    {
        $ret = array();
        $this->black->playerId = $this->playerId;
        if (!$this->black->getList($ret)){
            return [];
        }
        return $ret;
    }
}