<?php
/**
 *
 * @date 2022-3-29
 * @author JZW
 **/


namespace Game\Model\Friend;


use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\TemplateDefine;
use Game\Data\Friends\FriendsRequestData;

class FriendRequestModel
{
    use TemplateHelp;

    private int $playerId;
    private int $respondentPlayerId;

    public FriendsRequestData $request;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setRespondentPlayerId($respondentPlayerId)
    {
        $this->respondentPlayerId = $respondentPlayerId;
    }

    public function __construct()
    {
        $this->request = new FriendsRequestData();
    }

    //申请好友
    public function applyForFriends(): bool
    {
        $this->request->playerId = $this->respondentPlayerId;
        $this->request->respondentPlayerId = $this->playerId;
        return $this->request->saveDB();
    }

    //删除申请
    public function delApply(): bool
    {
        $this->request->playerId = $this->playerId;
        $this->request->respondentPlayerId = $this->respondentPlayerId;
        return $this->request->deleteDB($ret);
    }

    public function searchList(): array
    {
        $this->request->playerId = $this->playerId;
        if (!$this->request->getList($ret)){
            return [];
        }
        $result = [];
        foreach ($ret as $id => $val) {
            if ($id == $this->playerId) {
                continue;
            }
            $result[$id] = $val;
        }

        return $result;
    }
}
