<?php
/**
 * 随机好友搜索公共表
 * @date 2022-3-30
 * @author JZW
 **/
namespace Game\Model\Friend;

use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;

class FriendRandomModel
{
    use CommonDBHandler;

    private int $playerId;
    private int $score;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setScore($score)
    {
        $this->score = $score;
    }

    //修改性别和升级段位后添加
    public function addData(): bool
    {
        if ($this->playerId <= 0) {
            return false;
        }
        return $this->addCommonRank(DBTableDefine::TABLE_COMMON_FRIENDS, 0, $this->playerId, $this->score);
    }

    public function searchData($start, $stop, &$result): bool
    {
        return $this->searchCommonRank(DBTableDefine::TABLE_COMMON_FRIENDS, 0, $start, $stop, $result);
    }
}