<?php
/**
 *
 * @date 2022-4-21
 * @author JZW
 **/


namespace Game\Model\Friend;


use Game\Data\Friends\FriendsLastGameData;
use Game\Logic\AccountLogic;
use Game\Logic\GenerateAiLogic;
use Game\Logic\PaiweiLevelLogic;
use Game\Data\AccountData;
use Game\Protobuf\AIInfo;
use Game\Protobuf\GCPVPMatchingSuccess;

class FriendLastGameModel
{
    use GenerateAiLogic;
    use AccountLogic;
    use PaiweiLevelLogic;

    public int $playerId;
    public int $gameId;  //比赛ID
    public string $ext;
    public int $size = 20;

    private FriendsLastGameData $game;


    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }


    public function __construct()
    {
        $this->game = new FriendsLastGameData();
    }

    public function updateLastGameRecord(int $gameId, array $playerRank, int $mapId, string $matchResultStr): bool
    {
        $matchResult = new GCPVPMatchingSuccess();
        $matchResult->mergeFromJsonString($matchResultStr);
        //整理AI信息
        $aiInfoArray = array();
        foreach ($matchResult->getAInfo() as $aiInfo) {
            /**
             * @var AIInfo $aiInfo
             */
            $aiInfoArray[$aiInfo->getPlayerId()] = $aiInfo;
        }
        $param = [
            AccountData::DB_LEVEL,
            AccountData::DB_RoleId,
            AccountData::DB_NICK_NAME,
            AccountData::DB_HEAD,
            AccountData::DB_GENDER,
        ];
        $player = [];
        foreach ($playerRank as $Id => $rank) {
            //查询AI车的信息
            if ($this->checkIsAIPlayer($Id)) {
                //查询AI信息
                $aiInfo = $aiInfoArray[$Id];
                $tmp = [
                    "Ranking" => $rank,
                    AccountData::DB_NICK_NAME => $aiInfo->getNickName(),
                    AccountData::DB_HEAD => $aiInfo->getHead(),
                    AccountData::DB_LEVEL => 1,
                    AccountData::DB_GENDER => $aiInfo->getGender(),
                    "Dan" => 1,
                ];
            }else{
                $rInfo = $this->getAccountPropertyArr($Id, $param);

                $paiWei = $this->getTargetPaiWeiLevel($Id);
                $dan = $paiWei->levelId;

                $tmp = [
                    "Ranking" => $rank,
                    AccountData::DB_NICK_NAME => $rInfo[AccountData::DB_NICK_NAME],
                    AccountData::DB_HEAD => $rInfo[AccountData::DB_HEAD],
                    AccountData::DB_LEVEL => $rInfo[AccountData::DB_LEVEL],
                    AccountData::DB_GENDER => $rInfo[AccountData::DB_GENDER],
                    "Dan" => $dan,
                ];
            }

            $player[$Id] = $tmp;
        }
        $this->game->playerId = $this->playerId;
        $this->game->gameId = $gameId;

        if (!$this->game->getGameData($ret)) {
            return true;
        }
        $ext = [
            FriendsLastGameData::DB_GameType => $ret[FriendsLastGameData::DB_GameType],
            FriendsLastGameData::DB_MapId => $mapId,
            FriendsLastGameData::DB_Time => $ret[FriendsLastGameData::DB_Time],  //开始比赛时间
            FriendsLastGameData::DB_Ext => $player,
        ];
        $this->game->ext = json_encode($ext);
        return $this->game->updateDB();
    }

    //查询所有比赛记录
    public function getLastList(): array
    {
        $this->game->playerId = $this->playerId;
        if (!$this->game->getList($res)){
            return [];
        }
        if (is_null($res)){
            return [];
        }
        $result = [];
        if (is_array($res)){
            foreach ($res as $id => $info){
                if ($id == $this->playerId){
                    continue;
                }
                $result[$id] = json_decode($info, true);
            }
        }
        return $result;
    }

    public function deleteMinTimeList(): bool
    {
        $this->game->playerId = $this->playerId;
        $IndexList = $this->game->getDBIndex();
        $num = count($IndexList) - $this->size;
        if ($num > 0){
            $timeList = [];
            foreach ($IndexList as $gameId => $content){
                $content = json_decode($content, true);
                if (!isset($content["Ext"]) || $content["Ext"] == ""){
                    $this->game->delList[] = $gameId;
                    $num--;
                    continue;
                }
                $timeList[$gameId] = $content["Time"];
            }
            if ($num > 0) {
                asort($timeList, SORT_NUMERIC);
                foreach ($timeList as $gameId => $time){
                    if ($num <= 0){
                        continue;
                    }
                    $this->game->delList[] = $gameId;
                    $num--;
                }
            }
            $this->game->deleteDB($ret);
        }
        return true;
    }
}