<?php

/**
 * 好友亲密关系
 */

namespace Game\Model\Friend;

use Framework\Lib\Utils;
use Framework\Logic\PacketCacheLogic;
use Game\Data\Friends\FriendIntimacyData;
use Game\Logic\Task\FriendIntimacyRewardLogic;
use Game\Protobuf\GCUpdateIntimacyTitle;
use Game\Protobuf\IntimacyTitle;
use Game\Protobuf\PacketId;

class FriendIntimacyModel
{
    use PacketCacheLogic;

    use FriendIntimacyRewardLogic;

    public int $playerId;
    private int $respondentPlayerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setRespondentPlayerId($respondentPlayerId)
    {
        $this->respondentPlayerId = $respondentPlayerId;
    }

    //检查与对方是否有亲密关系
    public function checkHasIntimacy(): bool
    {
        $data = new FriendIntimacyData($this->playerId, $this->respondentPlayerId);
        return $data->getIntimacyId() > 0;
    }

    //获取与对方的关系Id
    public function getTargetIntimacyId(): int
    {
        return (new FriendIntimacyData($this->playerId, $this->respondentPlayerId))->getIntimacyId();
    }

    //设置亲密关系
    public function setIntimacy(int $intimacyId)
    {
        $data = new FriendIntimacyData($this->playerId, $this->respondentPlayerId);
        $data->setIntimacyId($intimacyId);
        $message = new IntimacyTitle();
        $message->setPlayerId($this->respondentPlayerId);
        $message->setIntimacyId($intimacyId);
        if ($intimacyId != 0) {
            $message->setCreateTime(Utils::getServerTimestamp());
        }
        $sendMessage = new GCUpdateIntimacyTitle();
        $sendMessage->setTitle([$message]);
        $this->addPacket(
            PacketId::GC_GCUpdateIntimacyTitle,
            $sendMessage,
            $this->playerId
        );
        $data = new FriendIntimacyData($this->respondentPlayerId, $this->playerId);
        $data->setIntimacyId($intimacyId);
        $message->setPlayerId($this->playerId);
        if ($intimacyId != 0) {
            $message->setCreateTime(Utils::getServerTimestamp());
        }
        $sendMessage->setTitle([$message]);
        $this->addPacket(
            PacketId::GC_GCUpdateIntimacyTitle,
            $sendMessage,
            $this->respondentPlayerId
        );
        if ($intimacyId == 0) {
            //检查关闭亲密任务
            $this->checkCloseFriendIntimacyReward($this->playerId);
            $this->checkCloseFriendIntimacyReward($this->respondentPlayerId);
        } else {
            //检查开启亲密任务
            $this->checkOpenFriendIntimacyReward($this->playerId);
            $this->checkOpenFriendIntimacyReward($this->respondentPlayerId);
        }
    }

    //查询亲密关系数量
    public function getIntimacyNum(): int
    {
        return (new FriendIntimacyData($this->playerId, $this->respondentPlayerId))->getIntimacyNum();
    }

    //查询指定关系数量
    public function getIntimacyIdNun(int $intimacyId): int
    {
        $data = new FriendIntimacyData($this->playerId, $this->respondentPlayerId);
        $allIntimacy = $data->getAllIntimacy();
        $num = 0;
        foreach ($allIntimacy as $id => $value) {
            if ($value == $intimacyId) {
                $num++;
            }
        }
        return $num;
    }

    //查询自己全部亲密关系
    public function getAllMyIntimacy(): array
    {
        return (new FriendIntimacyData($this->playerId, $this->respondentPlayerId))->getAllIntimacy();
    }

    //删除亲密关系
    public function delIntimacyId()
    {
        $data = new FriendIntimacyData($this->playerId, $this->respondentPlayerId);
        $data->delIntimacyId();
        $data = new FriendIntimacyData($this->respondentPlayerId, $this->playerId);
        $data->delIntimacyId();
    }
}
