<?php

/**
 * 好友亲密度记录
 */

namespace Game\Model\Friend;

use Game\Data\Friends\FriendIntimacyMarkData;

class FriendIntimacyMarkModel
{
    public int $playerId;
    private int $respondentPlayerId;

    public const INDEX_MATCH_LIKE = 6;    //组队,点赞周亲密度上限记录
    public const INDEX_SEND_GIFT = 7;    //送礼周亲密度上限记录

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setRespondentPlayerId($respondentPlayerId)
    {
        $this->respondentPlayerId = $respondentPlayerId;
    }

    //获取组队和点赞 周记录值
    public function getMatchLikeNum(): int
    {
        return (new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId))
            ->getValue(self::INDEX_MATCH_LIKE);
    }

    //增加比赛 周记录
    public function addMatchPoint(int $addPoint): bool
    {
        return (new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId))
                ->addValue(self::INDEX_MATCH_LIKE, $addPoint);
    }

    //增加点赞 周记录
    public function addLikePoint(int $addPoint): bool
    {
        //双方都记录
        return (new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId))
            ->addValue(self::INDEX_MATCH_LIKE, $addPoint) &&
            (new FriendIntimacyMarkData($this->respondentPlayerId, $this->playerId))
                ->addValue(self::INDEX_MATCH_LIKE, $addPoint);
    }

    //获取送礼 周记录值
    public function getSendGiftNum(): int
    {
        return (new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId))
            ->getValue(self::INDEX_SEND_GIFT);
    }

    //增加送礼 周记录
    public function addSendGiftPoint(int $addPoint): bool
    {
        return (new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId))
            ->addValue(self::INDEX_SEND_GIFT, $addPoint) &&
            (new FriendIntimacyMarkData($this->respondentPlayerId, $this->playerId))
                ->addValue(self::INDEX_SEND_GIFT, $addPoint);
    }

    //删除记录(删除好友后用)
    public function delIntimacyMark()
    {
        $data = new FriendIntimacyMarkData($this->playerId, $this->respondentPlayerId);
        $data->delValue(self::INDEX_MATCH_LIKE);
        $data->delValue(self::INDEX_SEND_GIFT);
        $data = new FriendIntimacyMarkData($this->respondentPlayerId, $this->playerId);
        $data->delValue(self::INDEX_MATCH_LIKE);
        $data->delValue(self::INDEX_SEND_GIFT);
    }

    //跨周清空表
    public function clearMarkData()
    {
        $data = new FriendIntimacyMarkData($this->playerId, $this->playerId);
        $data->clearTable(self::INDEX_MATCH_LIKE);
        $data->clearTable(self::INDEX_SEND_GIFT);
    }
}