<?php

/**
 * 好友亲密关系申请
 */

namespace Game\Model\Friend;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\Logic\PacketCacheLogic;
use Game\Config\GameConfig;
use Game\Constant\DBTableDefine;
use Game\Data\AccountData;
use Game\Data\Friends\FriendIntimacyApplyData;
use Game\Logic\AccountLogic;
use Game\Protobuf\GCIntimacyApplyInfo;
use Game\Protobuf\IntimacyApplyInfo;
use Game\Protobuf\PacketId;

class FriendIntimacyApplyModel
{
    use AccountLogic;
    use PacketCacheLogic;

    public int $playerId;
    private int $respondentPlayerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function setRespondentPlayerId($respondentPlayerId)
    {
        $this->respondentPlayerId = $respondentPlayerId;
    }

    //创建申请
    public function createIntimacyApply(int $applyId, int $intimacyId): bool
    {
        $data = new FriendIntimacyApplyData();
        $data->setApplyPlayerId($this->playerId);
        $data->setTargetPlayerId($this->respondentPlayerId);
        $data->setCreateTime();
        $data->setApplyId($applyId);
        $data->setIntimacyId($intimacyId);
        if (false == $data->createApply()) {
            LogMark::getInstance()->markDebug(
                "[FriendIntimacyApplyModel] createIntimacyApply fail",
                (array)$data
            );
            return false;
        }
        return true;
    }

    //给对方发送申请消息
    public function sendApplyMessageToTargetPlayer(int $applyId, int $intimacyId)
    {
        $message = new GCIntimacyApplyInfo();
        $message->setInfo([$this->getApplyMessageProtobuf($this->playerId, $applyId, $intimacyId)]);
        $this->addPacket(
            PacketId::GC_IntimacyApplyInfo,
            $message,
            $this->respondentPlayerId
        );
    }

    //申请消息 portobuf
    public function getApplyMessageProtobuf(int $applyPlayerId, int $applyId, int $intimacyId): IntimacyApplyInfo
    {
        $playerInfo = $this->searchPlayerInfo($applyPlayerId);
        $message = new IntimacyApplyInfo();
        $message->setPlayerId($applyPlayerId);
        $message->setIntimacyId($intimacyId);
        $message->setApplyId($applyId);
        $message->setCreteTime(Utils::getServerTimestamp());
        $message->setNickName($playerInfo[AccountData::DB_NICK_NAME]);
        return $message;
    }

    //根据applyId获取申请信息
    public function getApplyInfoByApplyId(int $applyId)
    {
        return (new FriendIntimacyApplyData())->getApplyData($applyId);
    }

    //检查是否有申请
    public function checkHasApply(): bool
    {
        $data = new FriendIntimacyApplyData();
        $data->setApplyPlayerId($this->respondentPlayerId);
        $data->setTargetPlayerId($this->playerId);
        return $data->getApplyId() > 0;
    }

    public function getMyApplyId(): int
    {
        $data = new FriendIntimacyApplyData();
        $data->setApplyPlayerId($this->respondentPlayerId);
        $data->setTargetPlayerId($this->playerId);
        return $data->getApplyId();
    }

    //查询关于自己的申请
    public function getMyApplyInfo(): array
    {
        $data = new FriendIntimacyApplyData();
        $data->setApplyPlayerId($this->respondentPlayerId);
        $data->setTargetPlayerId($this->playerId);
        return $data->getMyApply();
    }

    //删除申请信息
    public function delApplyInfo(int $applyPlayerId, int $targetPlayerId, int $applyId)
    {
        $data = new FriendIntimacyApplyData();
        $data->setApplyPlayerId($applyPlayerId);
        $data->setTargetPlayerId($targetPlayerId);
        $data->delApply($applyId);
    }

    //查询过期申请
    public function getExpireTimeApply(int $time): array
    {
        return (new FriendIntimacyApplyData())->searchExpireApply($time);
    }

    //删除错误索引
    public function delApplyIndex(int $applyId)
    {
        $data = new FriendIntimacyApplyData();
        $data->delApplyIndex($applyId);
    }

    // 创建唯一id
    public function makeApplyId()
    {
        //TODO:modelType临时使用
        $index = $this->getUidIndex();
        return Utils::makeObjectID(GameConfig::getInstance()->SERVER_ID(), 10, $index);
    }
}
