<?php

/**
 * 事件管理
 */

namespace Game\Model;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\DB\Handler\PlayerDBPipe;
use Game\Constant\DBTableDefine;

class EventModel
{
    use PlayerDBHandler;

    public int $playerId;
    private array $pipeEventList = array(); //批量创建用 eventId=>[$model . "-" . $key=>$value,..]

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function registerEventData(int $eventId, int $model, array $data): bool
    {
        if (!is_array($data) || empty($data)) {
            return false;
        }
        $arr = array();
        foreach ($data as $key => $value) {
            $arr[$model . "-" . $key] = $value;
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_EVENT,
            $this->playerId,
            $eventId,
            $arr
        );
    }

    //批量注册事件,创建账号用!!!
    public function pipeRegisterEvent()
    {
        foreach ($this->pipeEventList as $eventId => $data) {
            PlayerDBPipe::getInstance()->createTitle(
                DBTableDefine::TABLE_EVENT,
                $this->playerId,
                $eventId,
                $data
            );
        }
        $this->pipeEventList = array();
    }

    //批量添加事件,创建账号用!!!
    public function pipeAddRegisterEvent(int $eventId, int $model, array $data): bool
    {
        if (!is_array($data) || empty($data)) {
            return false;
        }
        foreach ($data as $key => $value) {
            $this->pipeEventList[$eventId][$model . "-" . $key] = $value;
        }
        return true;
    }

    /**
     * @param int $eventId
     * @param array $data [key=model-taskId,..]
     * @return bool
     */
    public function removeEvent(int $eventId, array $data): bool
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_EVENT,
            $this->playerId,
            $eventId,
            $data
        );
    }

    public function getEventByEventId(int $eventId): array
    {
        $result = array();
        $this->searchTitle(
            DBTableDefine::TABLE_EVENT,
            $this->playerId,
            $eventId,
            $result
        );
        return $result;
    }
}
