<?php
/**
 * 事件条件汇总模块
 * @date 2022/6/21/021
 * @author JZW
 **/

namespace Game\Model;


use Game\Data\EventConditionData;

class EventConditionModel
{
    public int $playerId = 0;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //增加值 返回新值
    public function addEventConditionValue(string $key, int $value): int
    {
        $data = new EventConditionData($this->playerId);
        $ret = 0;
        $data->increaseEventConditionDataValue($key, $value, $ret);
        return $ret;
    }

    //查询数据--不存在的key,返回值为0
    public function getEventConditionValue(array $keyList): array
    {
        $data = new EventConditionData($this->playerId);
        $result = $data->searchDB($keyList);
        $tmp = array();
        foreach ($keyList as $key) {
            if (is_bool($result[$key])) {
                $tmp[$key] = 0;
            } else {
                $tmp[$key] = (int)$result[$key];
            }
        }
        return $tmp;
    }

    //重置数据
    public function resetEventConditionValue(string $key)
    {
        $data = new EventConditionData($this->playerId);
        $data->resetEventConditionDataValue($key);
    }

    //删除数据
    public function delEventConditionKey(string $key)
    {
        $data = new EventConditionData($this->playerId);
        $data->delEventConditionDataKey($key);
    }
}