<?php
/**
 * 俱乐部
 */
namespace Game\Model\Club;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\CommonDataLogic;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateClubStore;
use Game\Constant\GameErrorCode;
use Game\Data\Club\ClubStoreData;
use Game\Logic\AccountLogic;
use Game\Logic\Club\ClubLogic;
use Game\Logic\MoneyLogic;
use Game\Logic\PaiweiLevelLogic;
use Game\Protobuf\GCBuyClubStoreItem;
use Game\Protobuf\GCCreateClub;
use Framework\Network\SendMessage;
use Game\Protobuf\GCGetClubStoreRecord;
use Game\Protobuf\PacketId;
use Game\Protobuf\StoreRecord;

class ClubStoreModel {
    use PlayerDBHandler;
    use AccountLogic;
    use PaiweiLevelLogic;
    use MoneyLogic;
    use CommonDataLogic;
    use ClubLogic;

    public  int                   $playerId;
    public  GCCreateClub          $joinClubMsg;


    public function __construct() {
        $this->joinClubMsg   = new GCCreateClub();
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function getPlayerID(): int {
        return $this->playerId;
    }
    // 增加购买记录与购买时间
    public function addBuyStoreRecord(int $id, int $num, $cfg): bool {
        $clubStoreData = new ClubStoreData($this->playerId);
        $seasonId = $cfg[TemplateClubStore::FlushedMatch];
        $beforeNum = $clubStoreData->searchStoreRecordByStoreID($id, $seasonId);
        $realNum = $beforeNum + $num;
        if(!$clubStoreData->addBuyStoreRecord($id, $realNum, $seasonId)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubStoreModel] add buy store record error!'
            );
            return false;
        }
        if(!$clubStoreData->addBuyStoreLastTime($id, Utils::getServerTimestamp(), $seasonId)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubStoreModel] add buy store record error!'
            );
            return false;
        }
        return true;
    }

    // 检测商店购买上限
    public function checkBuyLimit(int $id, int $num, array $cfg): bool {
        $clubStoreData = new ClubStoreData($this->playerId);
        $seasonId = $cfg[TemplateClubStore::FlushedMatch];
        $beforeNum = $clubStoreData->searchStoreRecordByStoreID($id, $seasonId);
        $realNum = $beforeNum + $num;

        $clubLevel = $this->getClubLevel();

        if(!isset($cfg[TemplateClubStore::LimitNum][$clubLevel])) {
            $this->GCSendBuyStoreItem(ClientErrorCode::ERROR_CLUB_NOT_BUY);
            return false;
        }

        if($realNum > $cfg[TemplateClubStore::LimitNum][$clubLevel]) {
            $this->GCSendBuyStoreItem(ClientErrorCode::ERROR_CLUB_STORE_BUY_MAX);
            return false;
        }
        return true;
    }

    // 获取本赛季购买次数记录
    public function getStoreRecord(array $arr, int $seasonID): array {
        $res = [];
        $clubStoreData = new ClubStoreData($this->playerId);

        foreach ($arr as $item) {
            $num = $clubStoreData->searchStoreRecordByStoreID($item[ClubStoreData::ID], $seasonID);
            $time = $clubStoreData->searchStoreLastTimeByStoreID($item[ClubStoreData::ID], $seasonID);
            array_push($res, [
                ClubStoreData::ID => $item[ClubStoreData::ID],
                ClubStoreData::Num => $num,
                ClubStoreData::Time => $time,
            ]);
        }
        return $res;
    }

    public function GCSendBuyStoreItem(int $code) {
        $buyMsg = new GCBuyClubStoreItem();
        $buyMsg->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyClubStoreItem, $buyMsg);
    }

    public function GCSendGetStoreRecord(array $res) {
        $data = [];
        if(!empty($res)) {
            foreach($res as $val) {
                $item = new StoreRecord();
                $item->setID($val[ClubStoreData::ID]);
                $item->setNum($val[ClubStoreData::Num]);
                $item->setTime($val[ClubStoreData::Time]);
                array_push($data, $item);
            }
        }
        $msg = new GCGetClubStoreRecord();
        $msg->setRecord($data);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetClubStoreRecord, $msg);
    }
}