<?php

/**
 * 赛车信息统计
 */

namespace Game\Model\Car;

use Game\Data\Car\CarStatisticsData;

class CarStatisticModel
{
    public int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    //获取赛车统计数据
    public function getCarStatisticDataByCarId(int $carId): ?array
    {
        return (new CarStatisticsData($this->playerId))->searchDBByCarId($carId);
    }

    public function getCarStatisticDataByCarUid(int $carUid): ?array
    {
        return (new CarStatisticsData($this->playerId))->searchDBByCarUId($carUid);
    }

    //初始赛车统计信息
    public function initCarStatisticData(int $carUid): array
    {
        return (new CarStatisticsData($this->playerId))->initData($carUid);
    }

    //报错赛车统计信息
    public function saveCarStatisticData(array $data, int $carUid): bool
    {
        return (new CarStatisticsData($this->playerId))->saveDB($data, $carUid);
    }
}
