<?php

/**
 * 福利活动
 */

namespace Game\Model\Activity;

use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Game\Constant\GameErrorCode;
use Game\Data\Activity\WelfareData;
use Game\Logic\Activity\WelfareLogic;


class WelfareModel
{
    use TemplateHelp;
    use WelfareLogic;

    // 7日新秀活动时间
    public const ACTIVITY_7NEW_TIME_LIMIT = 30 * 24 * 60 * 60;

    public const NOON_START  = 12;
    public const NOON_END    = 14;
    public const NIGHT_START = 20;
    public const NIGHT_END   = 22;

    // 天奖励领取
    public const NOON = 1; // 上午
    public const NIGHT = 2;

    public const STATE_NOT_REWARD = 0;      // 不可领取
    public const STATE_REWARD = 1;          // 可领取
    public const STATE_REWARD_COMPLETE = 2; // 已领取


    private int $playerId;
    public WelfareData $data;

    public function __construct()
    {
        $this->data = new WelfareData();
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
        $this->data->playerID = $playerId;
    }

    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    public function onRegister()
    {
        $week = date("w");
        $this->data->playerID = $this->playerId;
        $this->data->newNumber = 1;
        $this->data->newRecord = [];
        $this->data->loginRecord1 = [];
        $this->data->loginRecord2 = [];
        $this->data->weekRecord = [(int)$week];
        $this->data->registerDB();
    }

    public function resetLoginRecord(): bool {
        $this->data->loginRecord1 = [];
        $this->data->loginRecord2 = [];
        return $this->data->updateDB();
    }

    public function resetWeekRecord(): bool {
        $this->data->weekRecord = [];
        return $this->data->updateDB();
    }

    public function resetWeekLoginRecord(): bool {
        $this->data->weekLoginState = 0;
        return $this->data->updateDB();
    }

    public function getWelfareData(): void {
        $this->data->searchDB();
    }

    public function updateWelfare(): bool {
        return $this->data->updateDB();
    }

    // 心跳检测福利活动是否可以领取
    public function checkWelfareActivity(): void
    {
        $hour = date("H");
        $reward = 0;
        if($hour >= self::NOON_START && $hour <= self::NOON_END) {
            $reward = self::NOON;
        }
        if($hour >= self::NIGHT_START && $hour <= self::NIGHT_END) {
            $reward = self::NIGHT;
        }
        if($reward == 0) {
            return ;
        }
        $this->data->searchDB();
        if(!in_array($reward, $this->data->loginRecord1)) {
            $this->data->loginRecord1[] = $reward;
            $this->data->updateDB();
        }
    }

    /**
     * 登录 push 的timer 失效触发
     * @param array $expireData (uid->expireTime)
     * @return bool
     */
    public function timerExpire(array $expireData): bool
    {
        if(empty($expireData)) {
            LogMark::getInstance()->markWarn(GameErrorCode::TIMER_EXPIRE_DATA_ERROR,
                '[WelfareModel] timerExpire array empty!');
            return false;
        }
        $hour = date("H");
        $reward = 0;
        if($hour >= self::NOON_START && $hour <= self::NOON_END) {
            $reward = self::NOON;
        }
        if($hour >= self::NIGHT_START && $hour <= self::NIGHT_END) {
            $reward = self::NIGHT;
        }
        if($reward == 0) {
            return true;
        }
        $this->data->searchDB();
        if(!in_array($reward, $this->data->loginRecord1)) {
            $this->data->loginRecord1[] = $reward;
            $this->data->updateDB();
        }
        return true;
    }
}
