<?php

/**
 * 限时活动登录
 */

namespace Game\Model\Activity;

use Framework\Logic\TemplateHelp;
use Game\Data\Activity\TaskExchangeLoginData;
use Game\Model\Task\Manager\ExchangeTaskManager;


class TaskExchangeLoginModel
{
    use TemplateHelp;

    private int $playerId;
    public TaskExchangeLoginData $data;

    public function __construct()
    {
        $this->data = new TaskExchangeLoginData();
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
        $this->data->playerID = $playerId;
    }

    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    public function getLimitTimeData($taskID): void {
        $this->data->searchDB($taskID);
    }

    public function updateLimitTimeData($taskID): bool {
        return $this->data->updateDB($taskID);
    }

    public function getExchangeTask($taskIds): array {
        $exchange = new ExchangeTaskManager();
        $exchange->setPlayerId($this->playerId);
        return $exchange->getExchangeTask($taskIds);
    }
}
