<?php

/**
 * 大乱斗玩家信息
 */

namespace Game\Model\Activity;

use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\TemplateDefine;
use Game\Data\Activity\ScuffleData;
use Game\Protobuf\GCSyncScuffleData;
use Game\Protobuf\PacketId;

class ScuffleModel
{
    use TemplateHelp;

    private int $playerId;

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
    }

    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    //初始化骰子点数和大乱斗积分
    public function onRegister()
    {
        $scuffleData = new ScuffleData($this->playerId);
        $scuffleData->initScuffleData();
        $scuffleData->registerDB();
    }

    //活动更新 检查重置
    public function syncCommonData(int $myIndex, int $commonIndex)
    {
        if ($this->playerId == 0) {
            return;
        }
        if ($myIndex == 0) {
            //新号 不需要重置
            return;
        }
        LogMark::getInstance()->markDebug(
            "[ScuffleModel] scuffle activity change,Reset ScuffleData",
            array(
                "oldSeasonId" => $myIndex,
                "newSeasonId" => $commonIndex
            )
        );
        $this->resetScuffle($commonIndex);
    }

    //活动更新 重置数据
    private function resetScuffle(int $activityId)
    {
        $scuffleData = $this->getScuffleData();
        $scuffleData->initScuffleData();
        //积分按比例折扣
        $pre = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Scuffle_Score_Discount,
            TemplateConst::ConstNum);
        $scuffleData->scuffleScore = (int)round($scuffleData->scuffleScore * $pre);
        if ($scuffleData->scuffleScore < ScuffleData::DEFAULT_SCORE) {
            $scuffleData->scuffleScore = ScuffleData::DEFAULT_SCORE;
        }
        $scuffleData->updateDB();
    }

    public function getScuffleData(): ScuffleData
    {
        $scuffleData = new ScuffleData($this->playerId);
        $scuffleData->searchDB();
        return $scuffleData;
    }

    //每日重置
    public function dailyReset()
    {
        $scuffleData = $this->getScuffleData();
        $scuffleData->scuffleDailyWin = 0;
        $scuffleData->updateDB();
    }

    /**
     * 比赛结束 增加骰子点数和积分 记录使用车Id
     * @param int $addPoint
     * @param int $addScore 可能为负
     * @param int $carId    本次使用的车Id
     * @param bool $teamIsWin   是否组队胜利
     */
    public function addScuffleData(int $addPoint, int $addScore, int $carId, bool $teamIsWin)
    {
        $scuffleData = $this->getScuffleData();
        //最大骰子点数
        $rollPointMax = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Scuffle_Roll_Point_Max,
            TemplateConst::ConstNum);
        //每个骰子需要分数
        $rollPoint = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Scuffle_Roll_Pre_Point,
            TemplateConst::ConstNum);
        if ((int)($scuffleData->scuffleRollPoint / $rollPoint) < $rollPointMax) {
            $scuffleData->scuffleRollPoint += $addPoint;
        }
        //增加乱斗积分
        $scuffleData->scuffleScore += $addScore;
        if ($scuffleData->scuffleScore < 0) {
            $scuffleData->scuffleScore = 0;
        }
        $useCar = json_decode($scuffleData->scuffleUseCar, true);
        if (!in_array($carId, $useCar)) {
            $useCar[] = $carId;
            $scuffleData->scuffleUseCar = json_encode($useCar);
        }
        if ($teamIsWin) {
            $scuffleData->scuffleDailyWin = 1;
        }
        $scuffleData->updateDB();
        $this->sendMessage($scuffleData);
    }

    //使用骰子
    public function roll(): bool
    {
        $scuffleData = $this->getScuffleData();
        $rollPoint = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Scuffle_Roll_Pre_Point,
            TemplateConst::ConstNum);
        if ($scuffleData->scuffleRollPoint >= $rollPoint) {
            $scuffleData->scuffleRollPoint -= $rollPoint;
            $scuffleData->updateDB();
            $this->sendMessage($scuffleData);
            return true;
        }
        return false;
    }

    //通知骰子和积分变化
    public function sendMessage(ScuffleData $scuffleData)
    {
        $sendMessage = new GCSyncScuffleData();
        $sendMessage->setScuffleRollPoint($scuffleData->scuffleRollPoint);
        $sendMessage->setScuffleScore($scuffleData->scuffleScore);
        SendMessage::getInstance()->sendClient(PacketId::GC_SyncScuffleData, $sendMessage);
    }
}
